
#  Searching  #

# searchString [<str>] - allows search string to be specified. Returns 
#  current searchstring if no arg.
proc searchString {args} {
    global searchString
    if {[llength $args] == 0} {
	return $searchString
    } else {
	set searchString [lindex $args 0]
    }
}
# find - bring up the find dialog
proc find {args} {alertnote "You must use the supersearch package."}
# findAgain - repeat search forward
proc findAgain {args} {alertnote "You must use the supersearch package."}
# findAgainBackward - repeat search backward
proc findAgainBackward {args} {alertnote "You must use the supersearch package."}
# findInNextFile - search next file.
proc findInNextFile {args} {alertnote "You must use the supersearch package."}
# rsearch - reverse incremental search, see 'isearch'.
proc rsearch {} {isearch "bckwd"}
# isearch - incremental search: searches w/o a dialog,
#  searches as you type the search pattern. Does not do
#  regular expression searches. 'matchWords' 
#  automatically set to false.
proc isearch {{dir "fwd"}} {
    set ignoreCase 1
    set patt ""
    set pos [getPos]
    set rexp 0
    
    set done 0
    while {!$done} {
	# check pattern validity
	if {$rexp && ([catch {regexp -- $patt {} dmy} dmy])} {
	    set prompt "building->: $patt"
	} else {
	    set prompt "search: $patt"
	} 
	switch -- [catch {status::prompt $prompt "searchComp $dir" "anything"} res] {
	    0 {
		# got a keystroke that triggered a normal end (e.g. <return>)
		#goto $pos
		#global errorInfo
		#echo $errorInfo
		message "Aborted: $patt"
		return
	    }
	    1 {
		# an error was generated
		if {[string match "missing close-brace" $res]} {
		    # must have typed a slash, so:
		    append patt "\\"
		    continue
		} else {
		    # alertnote $res
		    set done 1
		}
		
	    }
	    default {
		set done 1
	    }
	}
		  
    }
    
    message " Exited: $patt"
}
 
proc searchComp {direction curr {key 0} {mod 0}} {

    if {$direction != ""} {
	if {[string match $direction fwd]} {
	    set dir 1
	} else {
	    set dir 0
	} 
    }
    
    # build a string that represents all the modifiers pressed:
    # checking in this order cmd, shift, option, and ctrl
    if {[expr {$mod & 1}]} { append t "c" } else { append t "_" }
    if {[expr {$mod & 34}]} { append t "s" } else { append t "_" }
    if {[expr {$mod & 72}]} { append t "o" } else { append t "_" }
    if {[expr {$mod & 144}]} { append t "z" } else { append t "_" }
    
    scan $key %c decVal
    
    switch -- $t {
	"____" {
	    switch -- $decVal {
		29 {forwardChar ;		break; # right arrow; }
		28 {backwardChar ;		break; # left arrow; }
		30 {						break; # up arrow; }
		31 {						break; # down arrow; }
	    }
	}
    }
    
    switch -- $t {
	"____" - 
	"_s__" {
	    upvar patt pat
	    if {$curr != ""} {
		while {[string compare [string range $pat [string last $curr $pat] end] $curr] != 0} {
		    set newEnd [expr {[string length $pat] - 2}]
		    if {$newEnd < 0} {
			error "deleted past string start"
		    } 
		    set pat [string range $pat 0 $newEnd] 
		}
	    } 
	    
	    set preAppend $pat
	    append pat $key
	    message "search: $preAppend" 
	    upvar ignoreCase ign
	    set searchResult [search -n -f $dir -m 0 -i $ign -r 0 -- $pat [getPos]]
	    if {[llength $searchResult] == 0} {
		beep
	    } else {
		select [lindex $searchResult 0] [lindex $searchResult 1]
	    }
	    return $key
	    
	}
	"c___" {
	    switch -- $decVal {
		103 { set direction fwd;	   # (cmd g); }
		28 {beginningOfLine ;	break; # cmd left arrow; }
		29 {endOfLine ;		break; # cmd right arrow; }
	    }
	      
	}
	"___z" {
	    # If the user is using the emacs key bindings, check for ones that 
	    # make sense. All other control key combinations abort
	    if {[package::active emacs]} {
		switch -- $decVal {
		    6 {forwardChar ;		break; # cntrl-f; }
		    2 {backwardChar ;	break; # cntrl-b; }
		    1 {beginningOfLine ;	break; # cntrl-a; }
		    5 {endOfLine ;		break; # cntrl-e; }
		    4 {deleteSelection ;	break; # cntrl-d; }
		    10 {killLine ;		break; # cntrl-k; }
		}
	    } 
	    # See if user has requested to find another match, either searchForward 
	    # (cntrl-s) or reverseSearch (cntrl-r). Set flag accordingly
	    switch -- $decVal {
		115 - 19 { set direction fwd; # (cntrl-s); }
		114 - 18 { set direction bckwd; # (cntrl-r); }
		default {return {} }
	    }
	}
	"c_o_" {
	    switch $decVal {
		169 { set direction bckwd; # (cmd-opt 'g'); }
		default {return {} }
	    }
	    
	}
	default {
	    beep
	    error "modifier combination has no meaningful bindings with respect to regIsearch"
	}
    }
    # handle direction flag if it got set above
    if {$direction != ""} {
	upvar patt pat
	upvar ignoreCase ign
	if {[string match $direction fwd]} {
	    set dir 1
	    set search_start [pos::math [getPos] + 1]
	} else {
	    set dir 0
	    set search_start [pos::math [getPos] - 1]
	} 
	set searchResult [search -n -f $dir -m 0 -i $ign -r 0 -- $pat $search_start]
	if {[llength $searchResult] == 0} {
	    beep
	} else {
	    select [lindex $searchResult 0] [lindex $searchResult 1]
	}
	return {}
    } 
}

# replace - replace the current selection
proc replace {args} {alertnote "You must use the supersearch package."}
# replaceAll - replace all further occurrences in the current file.
proc replaceAll {args} {alertnote "You must use the supersearch package."}
# replace&FindAgain - replace the current selection and find next 
#  occurrence.
proc replace&FindAgain {args} {alertnote "You must use the supersearch package."}
# search  [options] <pattern> <pos> - 
#  -f <num>		- go forward?
#  -r <num>		- regular expression?
#  -s			- save previous search string and search flags.
#  -i <num>		- ignore case?
#  -m <num>		- match words?
#  -n			- failed search still returns TCL_OK, but null string.
#  -l <limit>	- limit on how search goes.
#  --	 		- next arg is the pattern.
#
#  Searches for 'pattern' from position 'pos'.  If the search succeeds, a 
#  list of two positions will be returned.  The first is the starting position 
#  of the match, the second is one past the last character. If no '-n', 
#  TCL_ERROR returned.
proc search {args} {
    array set opts {-r 0 -f 1 -m 0 -i 1}
    getOpts {-r -f -m -i -l}
    set switches ""
    set expr [lindex $args 0]
    if {$opts(-r)} {
	lappend switches "-regexp"
	# this isn't ideal but is better than nothing!
	regsub -all {\[\\w} $expr "\[a-zA-Z_" expr
	regsub -all {\\w} $expr {[a-zA-Z_]} expr
	regsub -all {\\t} $expr "\t" expr
    }
    #echo "search $expr"
    if {[info exists opts(-l)]} {
	set limit "$opts(-l)"
    } else {
	if {$opts(-f)} {
	    set limit end
	} else { 
	    set limit 1.0 
	}
    }
    
    if {$opts(-i)} {lappend switches "-nocase"}
    global win::tk win::Active tw::count
    set w $win::tk([lindex $win::Active 0])
    if {$opts(-f)} {
	set from [lindex $args 1]
	lappend switches "-forward"
    } else {
	lappend switches "-backward"
	set from "[lindex $args 1] +1c"
    }
    set found [uplevel 1 $w search $switches -count ::tw::count -- \
      [list $expr $from $limit]]
    if {$found != ""} {
	return [list $found [text_cmd index "$found + ${tw::count}c"]]
    } else {
	if {[info exists opts(-n)]} {
	    return ""
	} else {
	    error "not found"
	}
    }
}
# should be ".al0.text search ?switches? pattern index ?stopIndex?
# must be -forward, -backward, -exact, -regexp, -nocase, -count, or --
