/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.wizards;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.BuilderChooser;
import net.sourceforge.texlipse.templates.ProjectTemplateManager;
import net.sourceforge.texlipse.wizards.TexlipseProjectAttributes;
import net.sourceforge.texlipse.wizards.TexlipseWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class TexlipseProjectCreationWizardPage
extends TexlipseWizardPage {
    private Text projectNameField;
    private Text projectLocationField;
    private Text languageField;
    private Text descriptionField;
    private List templateList;
    private Label typeLabel;
    private BuilderChooser outputChooser;
    private String workspacePath;

    public TexlipseProjectCreationWizardPage(TexlipseProjectAttributes attributes) {
        super(0, attributes);
    }

    public void createComponents(Composite parent) {
        this.workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().addTrailingSeparator().toOSString();
        this.createProjectNameControl(parent);
        this.addSpacer(parent, 2);
        this.createProjectLocationControl(parent);
        this.addSpacer(parent, 2);
        this.createOutputFormatControl(parent);
        this.addSeparator(parent);
        this.addSpacer(parent, 2);
        this.createLabels(parent);
        this.createTemplateControl(parent);
        this.updateEntries();
    }

    private void createOutputFormatControl(Composite parent) {
        this.outputChooser = new BuilderChooser(parent);
        GridData ngd = new GridData(768);
        ngd.horizontalSpan = 2;
        this.outputChooser.getControl().setLayoutData((Object)ngd);
        this.outputChooser.setSelectedBuilder(TexlipsePlugin.getDefault().getPreferenceStore().getInt("builderNum"));
        String o = this.attributes.getOutputFile();
        this.attributes.setOutputFile(String.valueOf(o.substring(0, o.lastIndexOf(46) + 1)) + this.outputChooser.getSelectedFormat());
        this.attributes.setOutputFormat(this.outputChooser.getSelectedFormat());
        this.outputChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String o = TexlipseProjectCreationWizardPage.this.attributes.getOutputFile();
                TexlipseProjectCreationWizardPage.this.attributes.setOutputFile(String.valueOf(o.substring(0, o.lastIndexOf(46) + 1)) + TexlipseProjectCreationWizardPage.this.outputChooser.getSelectedFormat());
                TexlipseProjectCreationWizardPage.this.attributes.setOutputFormat(TexlipseProjectCreationWizardPage.this.outputChooser.getSelectedFormat());
                TexlipseProjectCreationWizardPage.this.attributes.setBuilder(TexlipseProjectCreationWizardPage.this.outputChooser.getSelectedBuilder());
            }
        });
    }

    private void createProjectNameControl(Composite composite) {
        Composite c = new Composite(composite, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        GridData lgd = new GridData(768);
        lgd.horizontalSpan = 2;
        c.setLayoutData((Object)lgd);
        Label label = new Label(c, 16384);
        label.setText(TexlipsePlugin.getResourceString("projectWizardNameLabel"));
        label.setToolTipText(TexlipsePlugin.getResourceString("projectWizardNameTooltip"));
        label.setLayoutData((Object)new GridData());
        this.projectNameField = new Text(c, 2052);
        this.projectNameField.setText(this.attributes.getProjectName());
        this.projectNameField.setToolTipText(TexlipsePlugin.getResourceString("projectWizardNameTooltip"));
        this.projectNameField.setLayoutData((Object)new GridData(768));
        this.projectNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TexlipseProjectCreationWizardPage.this.projectNameField.isDisposed()) {
                    TexlipseProjectCreationWizardPage.this.validateProjectName(TexlipseProjectCreationWizardPage.this.projectNameField.getText());
                    if (!TexlipseProjectCreationWizardPage.this.projectLocationField.isEnabled()) {
                        TexlipseProjectCreationWizardPage.this.projectLocationField.setText(String.valueOf(TexlipseProjectCreationWizardPage.this.workspacePath) + TexlipseProjectCreationWizardPage.this.projectNameField.getText());
                    }
                }
            }
        });
        Label mainLabel = new Label(c, 16384);
        mainLabel.setText(TexlipsePlugin.getResourceString("propertiesLanguage"));
        mainLabel.setToolTipText(TexlipsePlugin.getResourceString("propertiesLanguageDescription"));
        mainLabel.setLayoutData((Object)new GridData());
        this.languageField = new Text(c, 2052);
        this.languageField.setText(this.attributes.getLanguageCode());
        this.languageField.setToolTipText(TexlipsePlugin.getResourceString("propertiesLanguageDescription"));
        this.languageField.setLayoutData((Object)new GridData());
        new AutoCompleteField((Control)this.languageField, (IControlContentAdapter)new TextContentAdapter(), Locale.getISOLanguages());
        this.languageField.setTextLimit(2);
        this.languageField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TexlipseProjectCreationWizardPage.this.languageField.isDisposed()) {
                    String text = TexlipseProjectCreationWizardPage.this.languageField.getText();
                    IStatus status = TexlipseProjectCreationWizardPage.this.createStatus(0, "");
                    if (text.length() != 2 || Arrays.binarySearch(Locale.getISOLanguages(), text) < 0) {
                        status = TexlipseProjectCreationWizardPage.this.createStatus(2, TexlipsePlugin.getResourceString("projectWizardLanguageCodeError"));
                    }
                    TexlipseProjectCreationWizardPage.this.attributes.setLanguageCode(text);
                    TexlipseProjectCreationWizardPage.this.updateStatus(status, TexlipseProjectCreationWizardPage.this.languageField);
                }
            }
        });
    }

    private void createProjectLocationControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(TexlipsePlugin.getResourceString("projectWizardLocationTitle"));
        group.setLayout((Layout)new GridLayout());
        GridData lgd = new GridData(768);
        lgd.horizontalSpan = 2;
        group.setLayoutData((Object)lgd);
        final Button createLocalProjectButton = new Button((Composite)group, 16400);
        createLocalProjectButton.setLayoutData((Object)new GridData());
        createLocalProjectButton.setText(TexlipsePlugin.getResourceString("projectWizardLocationLocal"));
        createLocalProjectButton.setSelection(true);
        createLocalProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!createLocalProjectButton.getSelection()) {
                    return;
                }
                Control[] c = TexlipseProjectCreationWizardPage.this.projectLocationField.getParent().getChildren();
                int i = 0;
                while (i < c.length) {
                    c[i].setEnabled(false);
                    ++i;
                }
                TexlipseProjectCreationWizardPage.this.projectLocationField.setText(String.valueOf(TexlipseProjectCreationWizardPage.this.workspacePath) + TexlipseProjectCreationWizardPage.this.projectNameField.getText());
                TexlipseProjectCreationWizardPage.this.attributes.setProjectLocation(null);
                TexlipseProjectCreationWizardPage.this.updateStatus(TexlipseProjectCreationWizardPage.this.createStatus(0, ""), TexlipseProjectCreationWizardPage.this.projectLocationField);
            }
        });
        final Button createExternalProjectButton = new Button((Composite)group, 16400);
        createExternalProjectButton.setLayoutData((Object)new GridData());
        createExternalProjectButton.setText(TexlipsePlugin.getResourceString("projectWizardLocationExternal"));
        createExternalProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!createExternalProjectButton.getSelection()) {
                    return;
                }
                Control[] c = TexlipseProjectCreationWizardPage.this.projectLocationField.getParent().getChildren();
                int i = 0;
                while (i < c.length) {
                    c[i].setEnabled(true);
                    ++i;
                }
                TexlipseProjectCreationWizardPage.this.projectLocationField.setFocus();
                TexlipseProjectCreationWizardPage.this.projectLocationField.setText("");
            }
        });
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout cgl = new GridLayout();
        cgl.numColumns = 3;
        composite.setLayout((Layout)cgl);
        Label label = new Label(composite, 16384);
        label.setText(TexlipsePlugin.getResourceString("projectWizardLocationLabel"));
        label.setLayoutData((Object)new GridData());
        label.setEnabled(false);
        this.projectLocationField = new Text(composite, 2052);
        this.projectLocationField.setText(this.workspacePath);
        this.projectLocationField.setLayoutData((Object)new GridData(768));
        this.projectLocationField.setEnabled(false);
        this.projectLocationField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TexlipseProjectCreationWizardPage.this.projectLocationField.isDisposed() && TexlipseProjectCreationWizardPage.this.projectLocationField.isEnabled()) {
                    TexlipseProjectCreationWizardPage.this.validateProjectLocation(TexlipseProjectCreationWizardPage.this.projectLocationField.getText());
                }
            }
        });
        Button browseLocationButton = new Button(composite, 8);
        browseLocationButton.setText(TexlipsePlugin.getResourceString("openBrowse"));
        browseLocationButton.setLayoutData((Object)new GridData());
        browseLocationButton.setEnabled(false);
        browseLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                File dir;
                DirectoryDialog dialog = new DirectoryDialog(TexlipseProjectCreationWizardPage.this.projectLocationField.getShell());
                dialog.setMessage(TexlipsePlugin.getResourceString("projectWizardLocationSelect"));
                dialog.setText(TexlipsePlugin.getResourceString("projectWizardLocationSelect"));
                String current = TexlipseProjectCreationWizardPage.this.projectLocationField.getText();
                if (current == null || current.length() == 0) {
                    current = TexlipseProjectCreationWizardPage.this.workspacePath;
                }
                dialog.setFilterPath(current);
                String dirStr = dialog.open();
                if (dirStr != null && (dir = new File(dirStr)).exists() && dir.isDirectory()) {
                    TexlipseProjectCreationWizardPage.this.projectLocationField.setText(dir.getAbsolutePath());
                }
            }
        });
    }

    private void validateProjectLocation(String text) {
        IProject p;
        IStatus status;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String pName = this.projectNameField.getText();
        if ("".equals(pName)) {
            pName = "fdslajflj";
        }
        if ((status = workspace.validateProjectLocation(p = workspace.getRoot().getProject(pName), (IPath)new Path(text))).getSeverity() == 0) {
            this.attributes.setProjectLocation(text);
        }
        this.updateStatus(status, this.projectLocationField);
    }

    private void createLabels(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(TexlipsePlugin.getResourceString("projectWizardTemplateListLabel"));
        label.setToolTipText(TexlipsePlugin.getResourceString("projectWizardTemplateListTooltip"));
        label.setLayoutData((Object)new GridData());
        Composite c = new Composite(composite, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)new GridData(768));
        Label l = new Label(c, 16384);
        l.setText(TexlipsePlugin.getResourceString("projectWizardTemplateDescriptionLabel"));
        l.setToolTipText(TexlipsePlugin.getResourceString("projectWizardTemplateDescriptionTooltip"));
        l.setLayoutData((Object)new GridData());
        this.typeLabel = new Label(c, 131072);
        this.typeLabel.setToolTipText(TexlipsePlugin.getResourceString("projectWizardTemplateTypeTooltip"));
        this.typeLabel.setLayoutData((Object)new GridData(768));
    }

    private void createTemplateControl(Composite composite) {
        this.templateList = new List(composite, 2820);
        this.templateList.setItems(ProjectTemplateManager.loadTemplateNames());
        this.templateList.setLayoutData((Object)new GridData(1040));
        this.templateList.setToolTipText(TexlipsePlugin.getResourceString("projectWizardTemplateTooltip"));
        this.templateList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TexlipseProjectCreationWizardPage.this.attributes.setTemplate(TexlipseProjectCreationWizardPage.this.templateList.getSelection()[0]);
                TexlipseProjectCreationWizardPage.this.updateEntries();
            }
        });
        this.templateList.setSelection(0);
        this.attributes.setTemplate(this.templateList.getItem(0));
        this.descriptionField = new Text(composite, 2050);
        this.descriptionField.setToolTipText(TexlipsePlugin.getResourceString("projectWizardTemplateDescriptionTooltip"));
        this.descriptionField.setLayoutData((Object)new GridData(1808));
        this.descriptionField.setEditable(false);
    }

    private void updateEntries() {
        this.typeLabel.setText(this.templateType(this.attributes.getTemplate()));
        this.readProjectTemplateDescription(this.attributes.getTemplate());
    }

    private String templateType(String template) {
        URL templateUrl = TexlipsePlugin.getDefault().getBundle().getEntry("templates" + File.separator + template + ".tex");
        if (templateUrl == null) {
            return "User defined template";
        }
        return "System template";
    }

    private void readProjectTemplateDescription(String template) {
        URL templateUrl = TexlipsePlugin.getDefault().getBundle().getEntry("templates" + File.separator + template + ".tex");
        String userTemplate = null;
        if (templateUrl == null) {
            File userTemplateFolder = ProjectTemplateManager.getUserTemplateFolder();
            userTemplate = String.valueOf(userTemplateFolder.getAbsolutePath()) + File.separator + template + ".tex";
        }
        try {
            String line = null;
            BufferedReader r = templateUrl != null ? new BufferedReader(new InputStreamReader(templateUrl.openStream())) : new BufferedReader(new FileReader(userTemplate));
            StringBuffer sb = new StringBuffer();
            while ((line = r.readLine()) != null) {
                if (!line.startsWith("%%")) break;
                if (line.length() > 2) {
                    sb.append(line.substring(2));
                }
                sb.append('\n');
            }
            r.close();
            sb.toString();
            this.descriptionField.setText(sb.toString());
        }
        catch (IOException e) {
            TexlipsePlugin.log("Reading a description of template file:", e);
            this.descriptionField.setText("");
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validateProjectName(this.projectNameField.getText());
        }
    }

    private void validateProjectName(String text) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(text, 4);
        if (status.isOK()) {
            if (workspace.getRoot().getProject(text).exists()) {
                status = this.createStatus(4, TexlipsePlugin.getResourceString("projectWizardNameError"));
            }
            this.attributes.setProjectName(text);
        }
        this.updateStatus(status, this.projectNameField);
    }
}

