/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor.scanner;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class TexEnvironmentRule
implements IPredicateRule {
    protected IToken fToken;
    protected char[] fStartSequence = "\\begin".toCharArray();
    protected char[] fEndSequence = "\\end".toCharArray();
    protected char[][] fEnvName;
    protected boolean fStar;
    protected boolean fLastStar;
    protected int fLastEnv;

    public TexEnvironmentRule(String envName, IToken token) {
        this(envName, false, token);
    }

    public TexEnvironmentRule(String[] envNames, boolean star, IToken token) {
        this.fToken = token;
        this.fEnvName = new char[envNames.length][];
        int i = 0;
        while (i < envNames.length) {
            this.fEnvName[i] = envNames[i].toCharArray();
            ++i;
        }
        this.fStar = star;
    }

    public TexEnvironmentRule(String envName, boolean star, IToken token) {
        this.fToken = token;
        this.fEnvName = new char[1][];
        this.fEnvName[0] = envName.toCharArray();
        this.fStar = star;
    }

    protected IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
        this.fLastStar = true;
        this.fLastEnv = -1;
        if (resume) {
            while (scanner.read() != -1) {
            }
        } else {
            int c = scanner.read();
            if (c == this.fStartSequence[0] && this.sequenceDetected(scanner, this.fStartSequence) && this.endSequenceDetected(scanner)) {
                return this.fToken;
            }
            scanner.unread();
        }
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        int readChar = 1;
        while ((c = scanner.read()) != -1) {
            ++readChar;
            if (this.fEndSequence.length <= 0 || c != this.fEndSequence[0] || !this.sequenceDetected(scanner, this.fEndSequence)) continue;
            return true;
        }
        this.unReadScanner(scanner, readChar);
        return false;
    }

    private boolean unReadScanner(ICharacterScanner scanner, int readChar) {
        int j = 0;
        while (j < readChar) {
            scanner.unread();
            ++j;
        }
        return false;
    }

    protected boolean sequenceDetected(ICharacterScanner scanner, char[] sequence) {
        int c;
        int readChar = 0;
        int i = 1;
        while (i < sequence.length) {
            int c2 = scanner.read();
            ++readChar;
            if (c2 != sequence[i]) {
                return this.unReadScanner(scanner, readChar);
            }
            ++i;
        }
        do {
            c = scanner.read();
            ++readChar;
        } while (this.isWhiteSpace((char)c));
        if (c != 123) {
            return this.unReadScanner(scanner, readChar);
        }
        if (this.fLastEnv == -1) {
            boolean found = false;
            int j = 0;
            while (j < this.fEnvName.length) {
                int readChar2 = 0;
                int i2 = 0;
                while (i2 < this.fEnvName[j].length) {
                    c = scanner.read();
                    ++readChar2;
                    if (c != this.fEnvName[j][i2]) {
                        this.unReadScanner(scanner, readChar2);
                        break;
                    }
                    if (i2 == this.fEnvName[j].length - 1) {
                        found = true;
                    }
                    ++i2;
                }
                if (found) {
                    this.fLastEnv = j;
                    readChar += readChar2;
                    break;
                }
                ++j;
            }
            if (!found) {
                return this.unReadScanner(scanner, readChar);
            }
        } else {
            int i3 = 0;
            while (i3 < this.fEnvName[this.fLastEnv].length) {
                c = scanner.read();
                ++readChar;
                if (c != this.fEnvName[this.fLastEnv][i3]) {
                    return this.unReadScanner(scanner, readChar);
                }
                ++i3;
            }
        }
        c = scanner.read();
        ++readChar;
        if (this.fStar && this.fLastStar && c == 42) {
            this.fLastStar = true;
            c = scanner.read();
            ++readChar;
        } else {
            this.fLastStar = false;
        }
        if (c != 125) {
            return this.unReadScanner(scanner, readChar);
        }
        return true;
    }

    private boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\n' || c == '\r' || c == '\t';
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.doEvaluate(scanner, resume);
    }

    public IToken getSuccessToken() {
        return this.fToken;
    }
}

