/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.texlipse.bibparser.analysis.DepthFirstAdapter;
import net.sourceforge.texlipse.bibparser.node.ABibeBibEntry;
import net.sourceforge.texlipse.bibparser.node.ABibstreBibEntry;
import net.sourceforge.texlipse.bibparser.node.ABibtaskBibEntry;
import net.sourceforge.texlipse.bibparser.node.ABibtex;
import net.sourceforge.texlipse.bibparser.node.AConcat;
import net.sourceforge.texlipse.bibparser.node.AEntryDef;
import net.sourceforge.texlipse.bibparser.node.AEntrybraceEntry;
import net.sourceforge.texlipse.bibparser.node.AEntryparenEntry;
import net.sourceforge.texlipse.bibparser.node.AIdValOrSid;
import net.sourceforge.texlipse.bibparser.node.AKeyvalDecl;
import net.sourceforge.texlipse.bibparser.node.ANumValOrSid;
import net.sourceforge.texlipse.bibparser.node.AStrbraceStringEntry;
import net.sourceforge.texlipse.bibparser.node.AStrparenStringEntry;
import net.sourceforge.texlipse.bibparser.node.AValueBValOrSid;
import net.sourceforge.texlipse.bibparser.node.AValueQValOrSid;
import net.sourceforge.texlipse.bibparser.node.TIdentifier;
import net.sourceforge.texlipse.bibparser.node.TStringLiteral;
import net.sourceforge.texlipse.bibparser.node.Token;
import net.sourceforge.texlipse.model.ParseErrorMessage;
import net.sourceforge.texlipse.model.ReferenceEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntryRetriever
extends DepthFirstAdapter {
    private List<ParseErrorMessage> warnings = new ArrayList<ParseErrorMessage>();
    private List<ParseErrorMessage> tasks = new ArrayList<ParseErrorMessage>();
    private List<ReferenceEntry> entries = new ArrayList<ReferenceEntry>();
    private ReferenceEntry currEntry;
    private StringBuffer currEntryInfo;
    private Token currEntryType;
    private String currField;
    private String crossref;
    private Set<String> currDefinedFields = new HashSet<String>();
    private Map<String, Integer> allDefinedKeys = new HashMap<String, Integer>();
    private static final Map<String, String> predefAbbrevs = new HashMap<String, String>();
    private Map<String, String> abbrevs = new HashMap<String, String>(predefAbbrevs);
    private Map<String, List<EntryText>> crossrefs = new HashMap<String, List<EntryText>>();
    private static final Map<String, ArrayList<String>> requiredFieldsPerType = new HashMap<String, ArrayList<String>>();

    static {
        predefAbbrevs.put("jan", "January");
        predefAbbrevs.put("feb", "February");
        predefAbbrevs.put("mar", "March");
        predefAbbrevs.put("apr", "April");
        predefAbbrevs.put("may", "May");
        predefAbbrevs.put("jun", "June");
        predefAbbrevs.put("jul", "July");
        predefAbbrevs.put("aug", "August");
        predefAbbrevs.put("sep", "September");
        predefAbbrevs.put("oct", "October");
        predefAbbrevs.put("nov", "November");
        predefAbbrevs.put("dec", "December");
        String[] article = new String[]{"author", "title", "journal", "year"};
        String[] book = new String[]{"title", "publisher", "year"};
        String[] booklet = new String[]{"title"};
        String[] conference = new String[]{"author", "title", "booktitle", "year"};
        String[] inbook = new String[]{"title", "publisher", "year"};
        String[] incollection = new String[]{"author", "title", "booktitle", "publisher", "year"};
        String[] inproceedings = new String[]{"author", "title", "booktitle", "year"};
        String[] manual = new String[]{"title"};
        String[] mastersthesis = new String[]{"author", "title", "school", "year"};
        String[] phdthesis = new String[]{"author", "title", "school", "year"};
        String[] techreport = new String[]{"author", "title", "institution", "year"};
        String[] proceedings = new String[]{"title", "year"};
        String[] unpublished = new String[]{"author", "title", "note"};
        requiredFieldsPerType.put("article", new ArrayList<String>(Arrays.asList(article)));
        requiredFieldsPerType.put("book", new ArrayList<String>(Arrays.asList(book)));
        requiredFieldsPerType.put("booklet", new ArrayList<String>(Arrays.asList(booklet)));
        requiredFieldsPerType.put("conference", new ArrayList<String>(Arrays.asList(conference)));
        requiredFieldsPerType.put("inbook", new ArrayList<String>(Arrays.asList(inbook)));
        requiredFieldsPerType.put("incollection", new ArrayList<String>(Arrays.asList(incollection)));
        requiredFieldsPerType.put("inproceedings", new ArrayList<String>(Arrays.asList(inproceedings)));
        requiredFieldsPerType.put("manual", new ArrayList<String>(Arrays.asList(manual)));
        requiredFieldsPerType.put("mastersthesis", new ArrayList<String>(Arrays.asList(mastersthesis)));
        requiredFieldsPerType.put("phdthesis", new ArrayList<String>(Arrays.asList(phdthesis)));
        requiredFieldsPerType.put("techreport", new ArrayList<String>(Arrays.asList(techreport)));
        requiredFieldsPerType.put("proceedings", new ArrayList<String>(Arrays.asList(proceedings)));
        requiredFieldsPerType.put("unpublished", new ArrayList<String>(Arrays.asList(unpublished)));
    }

    public List<ReferenceEntry> getEntries() {
        return this.entries;
    }

    public List<ParseErrorMessage> getWarnings() {
        return this.warnings;
    }

    public List<ParseErrorMessage> getTasks() {
        return this.tasks;
    }

    public void finishParse() {
        Set<Map.Entry<String, List<EntryText>>> keys = this.crossrefs.entrySet();
        for (Map.Entry<String, List<EntryText>> mapping : keys) {
            List<EntryText> crefs = mapping.getValue();
            for (EntryText et : crefs) {
                this.setMissingWarnings(et.token, et.definedFields);
                this.warnings.add(new ParseErrorMessage(et.token.getLine(), et.token.getPos() - 1, et.token.getText().length(), "Cross reference " + mapping.getKey() + " does not exist", 1));
            }
        }
    }

    @Override
    public void inABibtex(ABibtex node) {
    }

    @Override
    public void outABibtex(ABibtex node) {
    }

    @Override
    public void inABibeBibEntry(ABibeBibEntry node) {
    }

    @Override
    public void inABibstreBibEntry(ABibstreBibEntry node) {
    }

    @Override
    public void inABibtaskBibEntry(ABibtaskBibEntry node) {
    }

    @Override
    public void outABibeBibEntry(ABibeBibEntry node) {
    }

    @Override
    public void outABibstreBibEntry(ABibstreBibEntry node) {
    }

    @Override
    public void outABibtaskBibEntry(ABibtaskBibEntry node) {
        int start = node.getTaskcomment().getText().indexOf("TODO");
        String taskText = node.getTaskcomment().getText().substring(start + 4).trim();
        this.tasks.add(new ParseErrorMessage(node.getTaskcomment().getLine(), node.getTaskcomment().getPos(), taskText.length(), taskText, 0));
    }

    private void inAnAbbrev(TIdentifier tid, TStringLiteral tsl) {
        if (this.abbrevs.put(tid.getText(), tsl.getText()) != null) {
            this.warnings.add(new ParseErrorMessage(tid.getLine(), tid.getPos() - 1, tid.getText().length(), "String key " + tid.getText() + " is not unique", 1));
        }
    }

    @Override
    public void inAStrbraceStringEntry(AStrbraceStringEntry node) {
        this.inAnAbbrev(node.getIdentifier(), node.getStringLiteral());
    }

    @Override
    public void outAStrbraceStringEntry(AStrbraceStringEntry node) {
    }

    @Override
    public void inAStrparenStringEntry(AStrparenStringEntry node) {
        this.inAnAbbrev(node.getIdentifier(), node.getStringLiteral());
    }

    @Override
    public void outAStrparenStringEntry(AStrparenStringEntry node) {
    }

    private void inBibtexEntry(TIdentifier tid) {
        this.currEntry = new ReferenceEntry(tid.getText());
        this.currEntry.startLine = tid.getLine();
        this.currEntryInfo = new StringBuffer();
        Integer x = this.allDefinedKeys.put(this.currEntry.key, this.currEntry.startLine);
        if (x != null) {
            this.warnings.add(new ParseErrorMessage(this.currEntry.startLine, tid.getPos() - 1, this.currEntry.key.length(), "BibTex key " + this.currEntry.key + " is not unique: also defined in line " + x, 1));
        }
    }

    private void setMissingWarnings(Token t, Set<String> fields) {
        List reqFieldList = requiredFieldsPerType.get(t.getText());
        if (reqFieldList != null && !fields.containsAll(reqFieldList)) {
            for (String reqField : reqFieldList) {
                if (fields.contains(reqField)) continue;
                this.warnings.add(new ParseErrorMessage(t.getLine(), t.getPos() - 1, t.getText().length(), t + this.currEntry.key + " is missing required field " + reqField, 1));
            }
        }
    }

    private void outBibtexEntry(Token endToken) {
        List<EntryText> crefs;
        if (this.currEntry.author == null) {
            this.currEntry.author = "-";
        }
        if (this.currEntry.year == null) {
            this.currEntry.year = "-";
        }
        if (this.currEntry.journal == null) {
            this.currEntry.journal = "-";
        }
        this.currEntry.info = this.currEntryInfo.toString();
        this.currEntry.endLine = endToken.getLine();
        this.entries.add(this.currEntry);
        if (this.crossref != null) {
            crefs = this.crossrefs.get(this.crossref);
            if (crefs == null) {
                crefs = new ArrayList<EntryText>();
            }
            crefs.add(new EntryText(this.currEntryType, new HashSet<String>(this.currDefinedFields)));
            this.crossrefs.put(this.crossref, crefs);
            this.crossref = null;
        } else {
            this.setMissingWarnings(this.currEntryType, this.currDefinedFields);
        }
        if (this.crossrefs.containsKey(this.currEntry.key)) {
            crefs = this.crossrefs.remove(this.currEntry.key);
            for (EntryText et : crefs) {
                et.definedFields.addAll(this.currDefinedFields);
                this.setMissingWarnings(et.token, et.definedFields);
            }
        }
        this.currDefinedFields.clear();
    }

    @Override
    public void inAEntrybraceEntry(AEntrybraceEntry node) {
        this.inBibtexEntry(node.getIdentifier());
    }

    @Override
    public void outAEntrybraceEntry(AEntrybraceEntry node) {
        this.outBibtexEntry(node.getRBrace());
    }

    @Override
    public void inAEntryparenEntry(AEntryparenEntry node) {
        this.inBibtexEntry(node.getIdentifier());
    }

    @Override
    public void outAEntryparenEntry(AEntryparenEntry node) {
        this.outBibtexEntry(node.getRParen());
    }

    @Override
    public void inAEntryDef(AEntryDef node) {
    }

    @Override
    public void outAEntryDef(AEntryDef node) {
        this.currEntryInfo.append(node.getEntryName().getText().substring(1));
        this.currEntryInfo.append('\n');
        this.currEntryType = node.getEntryName();
        this.currEntryType.setText(this.currEntryType.getText().substring(1).toLowerCase());
    }

    @Override
    public void inAKeyvalDecl(AKeyvalDecl node) {
        this.currField = node.getIdentifier().getText().toLowerCase();
        this.currEntryInfo.append(this.currField);
        this.currEntryInfo.append(": ");
        if (!this.currDefinedFields.add(this.currField)) {
            this.warnings.add(new ParseErrorMessage(node.getIdentifier().getLine(), node.getIdentifier().getPos() - 1, this.currField.length(), "Field " + this.currField + " appears more than once in entry " + this.currEntry.key, 1));
        }
    }

    @Override
    public void outAKeyvalDecl(AKeyvalDecl node) {
        this.currEntryInfo.append('\n');
    }

    @Override
    public void inAConcat(AConcat node) {
    }

    @Override
    public void outAConcat(AConcat node) {
    }

    @Override
    public void inAValueBValOrSid(AValueBValOrSid node) {
    }

    @Override
    public void inAValueQValOrSid(AValueQValOrSid node) {
    }

    @Override
    public void outAValueBValOrSid(AValueBValOrSid node) {
        this.outAValueValOrSid(node.getStringLiteral().getText(), node.getStringLiteral());
    }

    @Override
    public void outAValueQValOrSid(AValueQValOrSid node) {
        TStringLiteral tsl = node.getStringLiteral();
        if (tsl != null) {
            this.outAValueValOrSid(tsl.getText(), tsl);
        } else {
            this.warnings.add(new ParseErrorMessage(this.currEntry.startLine, 1, this.currEntryType.getText().length(), String.valueOf(this.currField) + " is empty in " + this.currEntry.key, 1));
        }
    }

    private void outAValueValOrSid(String text, Token tsl) {
        String fieldValue = text.replaceAll("\\s+", " ");
        this.currEntryInfo.append(fieldValue);
        if ("author".equals(this.currField) || "editor".equals(this.currField)) {
            this.currEntry.author = fieldValue;
        } else if ("journal".equals(this.currField)) {
            this.currEntry.journal = fieldValue;
        } else if ("year".equals(this.currField)) {
            this.currEntry.year = fieldValue;
        } else if ("crossref".equals(this.currField)) {
            this.crossref = fieldValue;
        }
        if (fieldValue.equalsIgnoreCase("")) {
            this.warnings.add(new ParseErrorMessage(tsl.getLine(), tsl.getPos(), 0, String.valueOf(this.currField) + " is empty in " + this.currEntry.key, 1));
        }
    }

    @Override
    public void inANumValOrSid(ANumValOrSid node) {
    }

    @Override
    public void outANumValOrSid(ANumValOrSid node) {
        this.outAValueValOrSid(node.getNumber().getText(), node.getNumber());
    }

    @Override
    public void inAIdValOrSid(AIdValOrSid node) {
    }

    @Override
    public void outAIdValOrSid(AIdValOrSid node) {
        TIdentifier tid = node.getIdentifier();
        String expansion = this.abbrevs.get(tid.getText());
        if (expansion != null) {
            this.outAValueValOrSid(expansion, tid);
        } else {
            this.warnings.add(new ParseErrorMessage(tid.getLine(), tid.getPos() - 1, tid.getText().length(), "The abbreviation " + tid.getText() + " is undefined", 1));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryText {
        Token token;
        Set<String> definedFields;

        public EntryText(Token t, Set<String> df) {
            this.token = t;
            this.definedFields = df;
        }
    }
}

