/*
  hzfont2bdf.c

  Copyright (1989) Ricky Yeung (yeung@june.cs.washington.edu)

  Program to convert Chinese fonts in hz format to X window bdf format.

  This program is free for general use.
*/


#include <stdio.h>
#include <ctype.h>
#include <string.h>

#define true 1
#define false 0

#define GBbegin 0x2121
#define GBend 0x7a7e

char *getenv();

extern char *HZbitmap();
extern loadHZfont();
extern int bn;

int hzbyte;	/* number of bytes per hanzi image */

char hzdir[80], libdir[100], fontdir[100];
int HZbm;

static char HZDIR[] = "HZDIR";
char hzfont[30], hzName[30];

#define DB(hi,lo)	(((hi)&0xFF) << 8 | (lo)&0xFF)
#define isGB(c)		((c)>=0x21 && (c)<=0x7E)


int index2GB (index)
    int index;
{
    int hi,lo;

    hi = index / 0x5e + 0x21;
    lo = index % 0x5e + 0x21;
    return(DB(hi,lo));
}


AllBlank (p)
    char *p;
{
    int i;
    
    for (i=0;i<hzbyte;i++)
	if (p[i]) return(0);
    return(1);
}


hexchar(i)
    int i;
{
    if (i<10) return('0'+i);
    else if (i<16) return('a'+i-10);
}
   
byte2chars (c, byte)
    char c, *byte;
{
    int hi,lo;

    hi = (c >> 4) & 0xf;
    lo = c & 0xf;
    byte[0] = hexchar(hi);
    byte[1] = hexchar(lo);
}


WriteBitmap (p,isodd,oddbyte,nibbles,n)
    char *p;
    int isodd,oddbyte,nibbles,n;
{
    char byte[2];
    int i;
    
    for (i=1;i<=hzbyte;i++)
    {
	byte2chars(*p, byte);
	p++;
	if (isodd && ((i+oddbyte)%nibbles)==0)
	    printf("%c0\n%c",byte[0],byte[1]);
	else if ((i%n)==0)
	{
	    if (isodd) printf("%c%c0\n",byte[0],byte[1]);
	    else printf("%c%c\n",byte[0],byte[1]);
	}
	else printf("%c%c",byte[0],byte[1]);
    }
}

#define LEN 100

main(argc, argv)
     int argc;
     char *argv[];
{
    char s[LEN], *p;
    int i,j,code,total=0,n,isodd,oddbyte,nibbles,b_char=55290;

  if (getenv(HZDIR) != NULL)
    {
      strcpy(hzdir, getenv(HZDIR));
      strcpy(libdir, hzdir);
      strcat(libdir, "/lib/");
      strcpy(fontdir, hzdir);
      strcat(fontdir, "/font/");
    }
  else
    {
      fprintf(stderr, "Please setenv %s appropriately.\n", HZDIR);
      exit(1);
    }
  
  switch (argc)
    {
      case 4:
	sscanf(argv[3], "%d", &b_char);
      case 3:
	strcpy(hzName, argv[1]);
	sscanf(argv[2], "%d", &HZbm);
	break;
      default:
	  fprintf(stderr, "usage: %s hzName size [all_zero_char_code]\n", argv[0]); 
	  exit(1);
    }
  
  sprintf(s, "%d", HZbm);
  strcpy(hzfont, hzName);
  strcat(hzfont, s);
  
  hzbyte = HZbm * HZbm / 8;
  loadHZfont();

    for (i=0;i<(bn/hzbyte);i++)
    {
	code = index2GB(i);
	p = HZbitmap(code);

	if (!AllBlank(p)) total++;
    }

    nibbles = HZbm/4;
    isodd = nibbles % 2;
        
    if (isodd) n = nibbles;
    else n = nibbles / 2;
    if (isodd) oddbyte = nibbles / 2;

    /* ad hoc */
    printf("STARTFONT 2.1\n");
    printf("FONT %s\n", hzfont);
    printf("SIZE %d 80 80\n", HZbm);
    printf("FONTBOUNDINGBOX %d %d 0 0\n",HZbm+2, HZbm+2);
    printf("STARTPROPERTIES 8\n");
    printf("FONTNAME_REGISTRY \"\"\n");
    printf("FAMILY_NAME \"Chinese Character\"\n");
    printf("FOUNDRY \"Generated by hzfont2bdf\"\n");
    printf("CHARSET_REGISTRY \"GB2312-80\"\n");
    printf("COPYRIGHT \"Generated by hzfont2bdf, please edit this line and FOUNDRY\"\n");
    printf("FONT_ASCENT %d\n",HZbm);
    printf("FONT_DESCENT 0\n");
    printf("DEFAULT_CHAR %d\n",b_char);
    printf("ENDPROPERTIES\n");

    printf("CHARS %d\n",++total);  /* plus default char */

    /* default char */
    printf("STARTCHAR hanzi1_default\n");
    printf("ENCODING %d\n",b_char);
    printf("SWIDTH 461 0\n");
    printf("DWIDTH %d 0\n",HZbm);
    printf("BBX %d %d 0 0\n",HZbm,HZbm);
    printf("BITMAP\n");
    for (i=0;i<HZbm;i++)
    {
	for (j=0;j<nibbles+isodd;j++)
	    putchar('0');
	putchar('\n');
    }
    printf("ENDCHAR\n");

    total = 0;
    for (i=0;i<(bn/hzbyte);i++)
    {
	code = index2GB(i);
	p = HZbitmap(code);

	if (!AllBlank(p))
	{
	    total++;
	    printf("STARTCHAR hanzi_%d\nENCODING %d\nSWIDTH 461 0\nDWIDTH %d 0\nBBX %d %d 0 0\nBITMAP\n", total, code | 0x8080, HZbm, HZbm, HZbm);
	    WriteBitmap(p,isodd,oddbyte,nibbles,n); 
	    printf("ENDCHAR\n");
	}
    }
    printf("ENDFONT\n");
    fprintf(stderr,"Total non-empty characters: %d\n", total);
}
