/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.summary.SumOfLogs;

public class GeometricMean
extends AbstractStorelessUnivariateStatistic {
    static final long serialVersionUID = -8178734905303459453L;
    private SumOfLogs sumOfLogs = new SumOfLogs();

    public void increment(double d) {
        this.sumOfLogs.increment(d);
    }

    public double getResult() {
        if (this.sumOfLogs.getN() > 0L) {
            return Math.exp(this.sumOfLogs.getResult() / (double)this.sumOfLogs.getN());
        }
        return Double.NaN;
    }

    public void clear() {
        this.sumOfLogs.clear();
    }

    public double evaluate(double[] values, int begin, int length) {
        return Math.exp(this.sumOfLogs.evaluate(values, begin, length) / (double)length);
    }

    public long getN() {
        return this.sumOfLogs.getN();
    }
}

