/* pfb2pfa.c === modified version of: */
/* pfb2ps.c - Copyright 1991-05-12 Erik Wallin, d87-ewa@nada.kth.se.
   This program may be distributed freely, modified or included in
   other free programs long as this copyright notice is still
   included.
*/

#define VERSION "1.0 (beta)"

#include <stdio.h>
#ifndef AIX
#   include <stdlib.h>
#endif
#include <string.h>
#include "defines.h"
#include "myopen.h"
#include "mymalloc.h"
#include "pfb2pfa.h"

#define getb() (getc (pfb_file))
#define getlen() (getb () | getb () << 8 | getb () << 16 | getb () << 24)

void give_usage ()
{
	fprintf (stderr, "Usage: pfb2pfa <somepfb>[.pfb]");
	fprintf (stderr, " [<somepfa>[.pfa]|-]\n");
	exit (UNSUCCESSFUL);
}

#ifdef __STDC__
void preamble (int argc, char ** argv)
#else
void preamble (argc, argv)
int argc;
char ** argv;
#endif
{
	if (argc == 1) give_usage ();
	pfb_file = my_open (argv [1], ".pfb", "rb");
	if (argc == 3)
	{
		if (strequ (argv [2], "-")) pfa_file = stdout;
		else pfa_file = my_open (argv [2], ".pfa", "w");
	}
	else pfa_file = my_open (argv [1], ".pfa", "w");
}

void postamble ()
{
	fclose (pfb_file);
	fclose (pfa_file);
	exit (SUCCESSFUL);
}

#ifdef __STDC__
void main (int argc, char ** argv)
#   else
void main (argc, argv)
int argc;
char ** argv;
#	endif
{
	int t;
	unsigned int l, i;
	unsigned char * buf;

	fprintf (stderr, "This is pfb2pfa, version %s\n", VERSION);
	preamble (argc, argv);
	while (! feof (pfb_file))
	{
		if (getb () != 128)
		{
			fprintf (stderr, "Magic number (128) not found ");
			fprintf (stderr, "or no input on input.\n");
			exit (UNSUCCESSFUL);
		}
		t = getb ();
		fprintf (stderr, "Type: %d, ", t);
		switch (t)
		{
			case 1:
			{
				l = (unsigned int) getlen ();
				fprintf (stderr, " plain text, length %ld\n",
					 (long) l);
				buf = (unsigned char *) my_malloc (l);
				if (fread (buf, sizeof (unsigned char),
						  l, pfb_file) != l)
				{
					fprintf (stderr, "Wrong length of ");
					fprintf (stderr, "ascii field: %ld ",
						 (long) l);
					fprintf (stderr, "or could not read ");
					fprintf (stderr, "file.\n");
					exit (UNSUCCESSFUL);
				}
#	ifdef unix
				for (i = 0; i < l; i ++)
				if (buf [i] == (unsigned char) '\r')
				buf [i] = (unsigned char) '\n';
#	    endif
				if (fwrite (buf, sizeof (unsigned char),
					    l, pfa_file) != l)
				{
					fprintf (stderr, "Could not write ");
					fprintf (stderr, "output.\n");
					exit (UNSUCCESSFUL);
				}
				free (buf);
			}
			break;
			case 2:
			{
				l = (unsigned int) getlen ();
				fprintf (stderr, " binary data, length %ld\n",
					 (long) l);
				buf = (unsigned char *) my_malloc (l);
				if (fread (buf, sizeof (unsigned char),
					   l, pfb_file) != l)
				{
					fprintf (stderr, "Wrong length of ");
					fprintf (stderr, "binary field: %ld ",
						 (long) l);
					fprintf (stderr, "or could not read ");
					fprintf (stderr, "file.\n");
					exit (UNSUCCESSFUL);
				}
				for (i = 0; i < l ; i ++)
				{
					fprintf (pfa_file, "%2.2X", buf [i]);
					if (! ((i + 1) % HEX_PER_LINE))
						fprintf (pfa_file, "\n");
				}
				fprintf (pfa_file, "\n");
				free (buf);
			}
			break;
			case 3:
			{
				fprintf (stderr, "End of file\n");
				postamble ();
			}
			break;
			default:
			{
				fprintf (stderr, "Unknown field type: %d\n", t);
				exit (UNSUCCESSFUL);
			}
		}
	}
	postamble ();
}
