/* al_init.c 2.9.0 92/07/06 -- split-off part of argloop.c
 *
-----------------------------------------------------------------------
    This software module copyright (c) 1990, 1991 Damian Cugley.  
    It is provided for free on an "as-is" basis.
    See the file COPYING for more information.
    See argloop(3) for more information on this software module.
-----------------------------------------------------------------------
 */

#include <sys/types.h>		/* ino_t */
#include <sys/stat.h>
#include <sys/param.h>		/* MAXPATHLEN */
#include <ctype.h>

#include "config.h"
#include "xstdio.h"		/* <stdio.h> plus prototypes */
#include "strmisc.h"		/* inludes <string(s).h> */
#include "argloop.h"

#ifndef MAXPATHLEN
#  define MAXPATHLEN 1024
#endif

#ifndef dir_sep_ch
#  define dir_sep_ch '/'
#endif

const char *progname;			/* this allocates real storage */

void
argloop_init_files(argv0, opts)
     const char *argv0;
     Argloop_options *opts;
{
  char   *getenv ARGS((const char *));
#ifndef toupper
  /*
   *  on some Sun systems, toupper is an (undeclared) function, not macro:
   */
  int	toupper ARGS((int));
#endif

  char	       	       *progname_uppercase;
  register char	       *t;
  FILE 	       	       *fp;
  char			scratch[MAXPATHLEN];
  struct stat		s;
  ino_t			home_rc = 0;
  
  progname = (progname = strrchr(argv0, dir_sep_ch)) ? progname + 1 : argv0;
				/* skip any directory component */

  /*
   *  "system" startup file
   */
#ifdef RCFIRST
  sprintf(scratch, "%s%crc.%s", config_rc_dir, dir_sep_ch, progname);
#else
  sprintf(scratch, "%s%c%s.rc", config_rc_dir, dir_sep_ch, progname);
#endif
  if (fp = fopen(scratch, "r"))
    argloop(al_file(fp), opts);

#ifdef NO_DOTRC
  /*
   *  Single-user systems have no need for a "user" rc file.
   *  Thus "project" rc file only
   */
  sprintf(scratch, "%s.rc", progname); 
  if (fp = fopen(scratch, "r")) argloop(al_file(fp), opts);
#else
  /*
   *  "user" rc file and "project" rc file.
   *  Check that these are not both the same file.
   */
  sprintf(scratch, "%s%c.%src", getenv("HOME"), dir_sep_ch, progname);
  if (fp = fopen(scratch, "r"))
    {
      fstat(fileno(fp), &s); home_rc = s.st_ino;
      argloop(al_file(fp), opts);
    }

#ifdef RCFIRST
  sprintf(scratch, "rc.%s", progname);
#else
  sprintf(scratch, "%s.rc", progname);
#endif
  if (fp = fopen(scratch, "r"))
    {
      fstat(fileno(fp), &s);
      if (s.st_ino != home_rc)	/* check not the same file as ~/.foorc */
	argloop(al_file(fp), opts);
    }
#endif

  /* 
   *  Read the PROGNAME environment variable, if set:
   */
  progname_uppercase = strdup(progname);
  for (t = progname_uppercase; *t; t++)
    if (isalpha(*t) && islower(*t)) *t = toupper(*t);
  sprintf(scratch, "%sINIT", progname_uppercase);
  if (t = getenv(scratch)) argloop(al_string(t), opts);
  xfree(progname_uppercase);
}
