/*
 * a few really global variables
 */

#ifdef _DEFINE
#define EXTERN 
#else
#define EXTERN extern
#endif

/* various flags and state variables */

EXTERN Boolean Debug;
EXTERN Boolean ExtraDebug;
EXTERN Boolean PreLoad;		/* preload the font descriptions? */
EXTERN Boolean BigPreLoad;	/* preload the font descriptions? */
EXTERN Boolean Batching;	/* batch raster-ops for speed (approx x3) */
EXTERN Boolean Mflag;		/* to say that -m was specified */
EXTERN int user_mag;		/* the value specified with -m */
EXTERN short main_state;	/* to say what we are currently doing */

EXTERN int h;				/* horizontal and vertical positions */
EXTERN int v;
EXTERN int hconv;			/* conversion factors from DVI to pixels */
EXTERN int vconv;

EXTERN char *PXLpath;
EXTERN char *PKpath;

EXTERN unsigned short totalpages;

struct char_entry {					/* character entry */
   unsigned short width, height;	/* width and height in pixels */
   short xOffset, yOffset;      	/* x offset and y offset in pixels */
   struct {
       Boolean isloaded;
       union {
	   long fileOffset;
	   struct pixrect *pixrectptr;
       } address;
   } where;
   int tfmw;						/* TFM width */
};

struct font_entry {				/* font entry */
   int k, c, s, d, a, l;
   char n[STRSIZE];				/* FNT_DEF command parameters */
   int font_mag;				/* computed from FNT_DEF s and d parameters */
								/* and only used for generating PXL filename */
   char name[STRSIZE];			/* full name of PXL file */
   int cache_slot;				/* slot in pixel_files, NOTCACHED if not */
   Boolean has_been_opened; 	/* to say if ReadCharDefs() has been done */
   struct char_entry ch[NPXLCHARS]; /* character information */
   struct font_entry *next;		/* next font in chain */
};

struct page_entry		/* for holding BOP info */
{
    long page_ptr;		/* offset in DVI file of command after BOP */
    int count_0;		/* TeX count 0 (page number) for this page */
};

EXTERN struct page_entry *pagepointers;

