/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid.skin;

import com.birosoft.liquid.skin.SkinElement;
import java.awt.Graphics;

public class SkinMenuItem
extends SkinElement {
    private int leftOffset;
    private int leftRolloverOffset;
    private int rightOffset;
    private int rightRolloverOffset;
    private int hsize;
    private int vsize;
    private int roundedSize;
    private boolean useDefaultButton = false;
    private boolean useSelectedButton = false;
    private boolean doneAllCalculations = false;

    public SkinMenuItem(String fileName, int leftOffset, int leftRolloverOffset, int rightOffset, int rightRolloverOffset, int roundedSize) {
        super(fileName, false);
        this.leftOffset = leftOffset;
        this.leftRolloverOffset = leftRolloverOffset;
        this.rightOffset = rightOffset;
        this.rightRolloverOffset = rightRolloverOffset;
        this.roundedSize = roundedSize;
        this.calculateSizes();
    }

    public void draw(Graphics g, boolean isEnabled, boolean isSelected, boolean isPushed, boolean isRollover, int pSizeX, int leftSize, int sizeY) {
        int offsetL = 0;
        int offsetR = 0;
        if (isSelected) {
            offsetL = this.leftRolloverOffset;
            offsetR = this.rightRolloverOffset;
        } else {
            offsetL = this.leftOffset;
            offsetR = this.rightOffset;
        }
        offsetL = this.hsize * offsetL;
        offsetR = this.hsize * offsetR;
        int offset = offsetL;
        int sizeX = leftSize;
        if (this.roundedSize > 0) {
            g.drawImage(this.getImage(), 0, 0, this.roundedSize, this.roundedSize, offset + 0, 0, offset + this.roundedSize, this.roundedSize, null);
            g.drawImage(this.getImage(), this.roundedSize, 0, sizeX - this.roundedSize, this.roundedSize, offset + this.roundedSize, 0, offset + this.hsize - this.roundedSize, this.roundedSize, null);
            g.drawImage(this.getImage(), sizeX - this.roundedSize, 0, sizeX, this.roundedSize, offset + this.hsize - this.roundedSize, 0, offset + this.hsize, this.roundedSize, null);
            g.drawImage(this.getImage(), 0, this.roundedSize, this.roundedSize, sizeY - this.roundedSize, offset + 0, this.roundedSize, offset + this.roundedSize, this.vsize - this.roundedSize, null);
            g.drawImage(this.getImage(), sizeX - this.roundedSize, this.roundedSize, sizeX, sizeY - this.roundedSize, offset + this.hsize - this.roundedSize, this.roundedSize, offset + this.hsize, this.vsize - this.roundedSize, null);
            g.drawImage(this.getImage(), 0, sizeY - this.roundedSize, this.roundedSize, sizeY, offset + 0, this.vsize - this.roundedSize, offset + this.roundedSize, this.vsize, null);
            g.drawImage(this.getImage(), this.roundedSize, sizeY - this.roundedSize, sizeX - this.roundedSize, sizeY, offset + this.roundedSize, this.vsize - this.roundedSize, offset + this.hsize - this.roundedSize, this.vsize, null);
            g.drawImage(this.getImage(), sizeX - this.roundedSize, sizeY - this.roundedSize, sizeX, sizeY, offset + this.hsize - this.roundedSize, this.vsize - this.roundedSize, offset + this.hsize, this.vsize, null);
        }
        g.drawImage(this.getImage(), this.roundedSize, this.roundedSize, sizeX - this.roundedSize, sizeY - this.roundedSize, offset + this.roundedSize, this.roundedSize, offset + this.hsize - this.roundedSize, this.vsize - this.roundedSize, null);
        offset = offsetR;
        sizeX = pSizeX - leftSize;
        g.translate(leftSize, 0);
        if (this.roundedSize > 0) {
            g.drawImage(this.getImage(), 0, 0, this.roundedSize, this.roundedSize, offset + 0, 0, offset + this.roundedSize, this.roundedSize, null);
            g.drawImage(this.getImage(), this.roundedSize, 0, sizeX - this.roundedSize, this.roundedSize, offset + this.roundedSize, 0, offset + this.hsize - this.roundedSize, this.roundedSize, null);
            g.drawImage(this.getImage(), sizeX - this.roundedSize, 0, sizeX, this.roundedSize, offset + this.hsize - this.roundedSize, 0, offset + this.hsize, this.roundedSize, null);
            g.drawImage(this.getImage(), 0, this.roundedSize, this.roundedSize, sizeY - this.roundedSize, offset + 0, this.roundedSize, offset + this.roundedSize, this.vsize - this.roundedSize, null);
            g.drawImage(this.getImage(), sizeX - this.roundedSize, this.roundedSize, sizeX, sizeY - this.roundedSize, offset + this.hsize - this.roundedSize, this.roundedSize, offset + this.hsize, this.vsize - this.roundedSize, null);
            g.drawImage(this.getImage(), 0, sizeY - this.roundedSize, this.roundedSize, sizeY, offset + 0, this.vsize - this.roundedSize, offset + this.roundedSize, this.vsize, null);
            g.drawImage(this.getImage(), this.roundedSize, sizeY - this.roundedSize, sizeX - this.roundedSize, sizeY, offset + this.roundedSize, this.vsize - this.roundedSize, offset + this.hsize - this.roundedSize, this.vsize, null);
            g.drawImage(this.getImage(), sizeX - this.roundedSize, sizeY - this.roundedSize, sizeX, sizeY, offset + this.hsize - this.roundedSize, this.vsize - this.roundedSize, offset + this.hsize, this.vsize, null);
        }
        g.drawImage(this.getImage(), this.roundedSize, this.roundedSize, sizeX - this.roundedSize, sizeY - this.roundedSize, offset + this.roundedSize, this.roundedSize, offset + this.hsize - this.roundedSize, this.vsize - this.roundedSize, null);
        g.translate(-leftSize, 0);
    }

    public int getHsize() {
        if (!this.doneAllCalculations) {
            this.calculateSizes();
            this.doneAllCalculations = true;
        }
        return this.hsize;
    }

    public int getVsize() {
        if (!this.doneAllCalculations) {
            this.calculateSizes();
            this.doneAllCalculations = true;
        }
        return this.vsize;
    }

    protected void calculateSizes() {
        int maxOffset = 0;
        if (this.leftOffset > maxOffset) {
            maxOffset = this.leftOffset;
        }
        if (this.leftRolloverOffset > maxOffset) {
            maxOffset = this.leftRolloverOffset;
        }
        if (this.rightOffset > maxOffset) {
            maxOffset = this.rightOffset;
        }
        if (this.rightRolloverOffset > maxOffset) {
            maxOffset = this.rightRolloverOffset;
        }
        this.hsize = this.getImage().getWidth(null) / (maxOffset + 1);
        this.vsize = this.getImage().getHeight(null);
    }
}

