NAME
    RISCOS::DrawFile::Object

SYNOPSIS
    Abstract base class for DrawFile objects.

DESCRIPTION
    `RISCOS::DrawFile::Object' provdes an abstract base class for
    DrawFile objects to inherit from. It provides various methods,
    some of which are inherited from `RISCOS::DrawFile::Common' and
    hence are also can be used on entire DrawFiles. See `the
    RISCOS::DrawFile::OpaqueObject manpage' for a minimal usable
    implementation of a DrawFile object.

  Methods

    new <data>, [<split function>, ...]
        Create a new DrawFile object. If `data' is not a reference
        it is assumed to be packed data, and the first 4 bytes are
        interpreted as an integer to get the object type. If a
        second argument is provided, a reference to code is assumed
        to be a split function with the same interface as
        drawplus_split_type, and will be called to split the
        extended object tag. If the second argument is a reference
        to an array it is assumed to give (type, layer, flags,
        spare), and these values are used in place of any derived
        from the first 4 bytes.

        If *data* is a reference to an object of the same class as
        the new object will become then it is `Clone()'ed and a list
        containing the clone returned. This allows all derived
        classes to easily implement a copy constructor.

        In scalar context `new' returns a blessed reference to the
        new object. In array context `new' returns a list (object,
        type, fonttable). *object* can be a reference to a list of
        objects, and *fonttable* is normally `undef'. See
        `RISCOS::DrawFile::FontTable' for the procedure to return a
        fonttable if found.

        Subclasses are expected to treat *data* as based on its
        type. If a subclass recieves a reference to a list rather
        than a single blessed reference then it should return
        immediately with that list, as `new' has been used as a copy
        constructor.

    scalar  raw bytes from a DrawFile

    scalar reference
            raw bytes from a DrawFile, with type, length and
            bounding box stripped

    array reference
            object dependent list of parameters to construct a new
            object


        If a second argument is proviced `new' sets the Layer, Flags
        and Spare members of the object to the supplied/split
        values. `new' never sets the Type member of the object - it
        is the responsibility of the derived class to store the Type
        member as if it needs to retain this information.

    PrePack <hash_reference>
        is provided as a hook to perform calculations immediately
        before saving a DrawFile. The hash reference is used to
        store the names of fonts needed in the FontTable, keys are
        font names, values the number of text objects that use that
        font (see `PrePack' in `RISCOS::DrawFile::Text' if you
        really must know). The default `PrePack' calls `BBox' and
        returns this value. This ensures that if any objects have
        been changed then their containing groups' bounding boxes
        will be upadated to reflect this. Derived classes should
        maintain this behaviour.

    Type
        returns the objects type. The default method looks in
        '`__TYPE'', which relies on the derived class storing it
        there. If your derived class does not need to store the Type
        you must override this method, typically with something like

            sub Type { 2; }


        Most classes don't need to store the type, as most classes
        deal with only one type of object. Exceptions include
        `OpaqueObject', which stores all unknown object types, and
        `Text', which implements normal text (type 1) and
        transformed text (type 12).

    Layer [<new_layer>]
        returns the current layer. If an argument is provided it is
        used to set the ojbects layer, and the old layer is
        returned.

    PackType [<type>]
        packs the object's tag (type) into a 4 byte string. If the
        object has a layer defined then DrawPlus extended tag format
        is used.

        The tag is taken from the first argument if supplied, else
        it is looked up as '`__TYPE''. Note that `new' in
        `RISCOS::DrawFile::Object' does not set '<__TYPE>', instead
        returning the value to the derived class.

    PackTypeSizeBBox <tag>, <size>, <bounding_box>
        returns a 24 byte string for the header common to all
        DrawFile objects (apart from FontTables).

        *type* is passed to `PackType' and the method `Size' is
        called if *size* is undefined. If *bounding_box* is defined
        then the object bounding box is taken from it - if
        *bounding_box* is an array reference should point to 4
        values, otherwise arguments three to six are taken to be the
        bounding box. If *bounding_box* is undefined then the method
        `BBox' is called, and (0,0,0,0) used if this returns
        `undef'.

        Usually `PackTypeSizeBBox' can be called with no arguments
        and it will do the right thing.

    Write <filehandle>, <fonttable>, ...
        writes the object to the given filehandle. The default
        implementation `print's the result of calling `Pack' with
        the remainder of the argument list. `Write' should return
        true unless there was an error.


  Methods supplied by `RISCOS::DrawFile::Common'

    Clone
        returns a copy of this object.

    BBox
        returns a reference to an array giving the bounding box, or
        `undef' if there is is no bounding box for this object
        (*i.e.* font tables, empty paths, option objects). Note that
        option objects and empty paths store a bounding box of
        (0,0,0,0) when saved. `BBox' will attempt to call
        `BBox_Calc' (which the derived class must provide) if the
        bounding box is currently unknown.

        As the returned array reference is the internal copy of the
        bounding box it must not be modified.

    Inside <bbox>

    InsideOrTouching <bbox>

    Intersect <bbox>

    IntersectOrTouching <bbox>

    Outside <bbox>
        return a reference to the object if it has the correct
        relationship with the bounding box (passed as an array
        reference), `undef' if it does not.


  Methods derived classes must supply

    In addition to the overriding above methods where appropriate
    (in particular `Type') derived classes must provide the
    following methods

    BBox_Calc
        (re)calculates the bounding box, returning a reference to an
        array, or undef if there is no bounding box. As it has no
        idea about the data it contains `OpaqueObject' simply
        returns the bounding box it was given when it was called.

    Size
        returns the size of the object when saved in a DrawFile

    Pack <undef>, fonttable, ...
        returns a scalar containing the object packed ready to save
        into a DrawFile.


BUGS
    Not tested enough.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

