#ifndef __STRHLP_H
#define __STRHLP_H


#include "misc.h"


///////////////////////////////////////////////////////////////////////////////
//
// prototypes
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//
// converts a string to netbios name (\\name)
//
// param:  server	- computer computer name
//
// return: converted string
//
// note:   if there is not enougth memory, an exception will be raised
//
///////////////////////////////////////////////////////////////////////////////

PSTR ServerAsAnsi(PSTR server);

///////////////////////////////////////////////////////////////////////////////
//
// converts a string to netbios name in unicode (\\name)
//
// param:  server	- computer computer name
//
// return: converted string
//
// note:   if there is not enougth memory, an exception will be raised
//
///////////////////////////////////////////////////////////////////////////////

PWSTR ServerAsUnicode(PSTR server);

///////////////////////////////////////////////////////////////////////////////
//
// converts a string to netbios name without leading backslashes
//
// param:  server	- computer computer name
//
// return: converted string
//
// note:   if there is not enougth memory, an exception will be raised
//
///////////////////////////////////////////////////////////////////////////////

PSTR ServerAsAnsiWithoutBackslashes(PSTR server);

///////////////////////////////////////////////////////////////////////////////
//
// converts a string to netbios name in unicode without leading backslashes
//
// param:  server	- computer computer name
//
// return: converted string
//
// note:   if there is not enougth memory, an exception will be raised
//
///////////////////////////////////////////////////////////////////////////////

PWSTR ServerAsUnicodeWithoutBackslashes(PSTR server);


#endif //#ifndef __STRHLP_H
